---
title: An Empirical Verification of Wide Networks Theory at BMVC 2022
description: My paper about testing the Polyak-Lojasiewicz theory on realistic networks
keywords: Polyak-Lojasiewicz condition in neural networks, convergence and generalization in neural networks, convergence guarantees in neural networks, generalization guarantees in neural networks, convergence of deep learning, generalization of deep learning, loss decrease prediction in neural networks
publish: true
date: 2022-11-27
uuid: 714ca7b8-55d0-458a-89fc-ae0caad0b2fd
tags:
  - #kind/work
  - #topic/machine-learning
  - #topic/optimization
  - #topic/deep-learning
  - #about/polyak-lojasiewicz-condition
---

Last week I presented my first paper "An Empirical Verification of Wide Networks Theory" at [BMVC 2022](https://bmvc2022.org) in London.
The experience has been fantastic, both because of the beautiful venue, a cricket field called [the Kia Oval](https://www.google.com/search?q=the+kia+oval&client=firefox-b-d&source=lnms&tbm=isch&sa=X&ved=2ahUKEwiw2de4psX7AhVIXsAKHe3gAw8Q_AUoAnoECAEQBA&biw=1080&bih=1328&dpr=1), and because of the stimulating discussions I had with other participants.

In this post I will briefly explain what my paper is about and appropriately link to all of its material (a video presentation and a poster).

<!-- More -->

What initially attracted my attention was the fact that there are actually a lot of theoretical papers on very wide networks (where the number of neurons in each layer is the cube of the number of examples you train your network on) which are able to give mathematical guarantees on convergence and generalization (via their relation with [Kernel Methods](https://en.wikipedia.org/wiki/Kernel_method) [(Archived)](https://web.archive.org/web/20221123/https://en.wikipedia.org/wiki/Kernel_method) given by the [Neural Tangent Kernel](https://arxiv.org/pdf/1806.07572.pdf) [(Archived)](https://web.archive.org/web/20221123/https://arxiv.org/pdf/1806.07572.pdf)), but those are not useful in practice, because typically deployed models are much less wide than what these theories assume.

On the other hand, typical models are still overparameterized, i.e. they have more neurons than the number of examples they are trained on, and they can be studied using the [Polyak-Lojasiewicz Condition](https://asset-pdf.scinapse.io/prod/2514742857/2514742857.pdf) [(Archived)](https://web.archive.org/web/20221123/https://asset-pdf.scinapse.io/prod/2514742857/2514742857.pdf), a generalization of convexity for which local minima are still global, even though no more unique.

What we do is to study the network optimization problem in the Polyak-Lojasiewicz framework, and expose the relation between the convergence speed in optimization and the conditioning of certain matrices of the network differentials, which gives us a way to measure crucial quantities during the optimization process and to verify certain parts of these theories.

In particular we focus on predicting the loss decrease in the next epoch by measuring the quantities at the current one, and in measuring conditioning more accurately during the whole optimization process. In doing so we find surprising results which actually contradict the ways in which theorems about wide networks reason, thus giving us hope that something more can be done to understand overparameterized realistic networks.

I hope that you are now more curious and want to have a look at [[BMVC 2022 Paper - An Empirical Verification of Wide Networks Theory.pdf|the paper]], [[BMVC 2022 Poster - An Empirical Verification of Wide Networks Theory.pdf|the poster]], [the code](https://gitlab.com/trenta3/empirical_pl_networks) [(Archived)](https://web.archive.org/web/20221123/https://gitlab.com/trenta3/empirical_pl_networks) or at least go visit [the paper website](https://dbalboni.gitlab.io/bmvc2022/) [(Archived)](https://web.archive.org/web/20221123/https://dbalboni.gitlab.io/bmvc2022/) with a video explanation of the paper.

